#Chapter 4: Comparisons

#xtp automatically exports cross tab to Table.Output
#GE 1
xtp(nes,enviro.jobs3,partyid3, wt)
#Add labeling to mosaic plot
xtp(nes,enviro.jobs3,partyid3, w=wt,ylab="Environment vs Jobs", xlab="Party ID",
 main="Environmental Attitudes, by Party ID")

#Mean comparisons
#GE 2
compmeans(nes$obama.therm, nes$partyid7,w=nes$wt, plot=FALSE) 
printC(compmeans(nes$obama.therm, nes$partyid7,w=nes$wt, plot=F))
#creat box plot
wtd.boxplot(nes$obama.therm~nes$partyid7, weights=nes$wt)
wtd.boxplot(data=nes,obama.therm~partyid7, weights=nes$wt)#also works...sometimes
#Add plotting elements
wtd.boxplot(nes$obama.therm~nes$partyid7, weights=nes$wt,
  xlab="Party Identification",
  ylab="Obama Rating",
  main="Obama Rating, by Party ID",
  col = "lightgray", 
  varwidth = TRUE)

#GE 3
#Line charts, first for mean comparisons
ddply(nes, .(partyid7), summarise,
  Obama.rating = wtd.mean(obama.therm, wt))
obj1=ddply(nes, .(partyid7), summarise,
  Obama.rating = wtd.mean(obama.therm, wt))
obj1

plotmeans(Obama.rating~partyid7, data=obj1, 
xlab="Party identification", 
ylab="Obama rating",
 
main="Ratings of Obama,\n by Party Identification",

n.label=F,
 
lwd=2,
 
pch=16, 

font.main=1)

#GE 4
#Line charts for indicators / dummies
levels(nes$enviro.jobs3)
nes$enviro.yes=as.numeric(nes$enviro.jobs3=="Environ")
freq(nes$enviro.yes,nes$wt)
freq(nes$enviro.jobs3,nes$wt)
ddply(nes, .(partyid3), summarise, 
   ProEnvir = wtd.mean(enviro.yes,wt))
obj1=ddply(nes, .(partyid3), summarise, 
  ProEnvir = wtd.mean(enviro.yes,wt))
print(obj1)
plotmeans(ProEnvir*100~partyid3, data=obj1, 
  xlab="Party ID",
  ylab="Percentage", 
  main="Percent Environment over Jobs, by Party",
  n.label=F,lwd=2,pch=16, font.main=1)

#GE 5
#Small datasets: mean comparisons + strip charts
compmeans(states$union07,states$region,plot=F)

stripchart(union07 ~ region, data=states,
    xlab="Region", ylab="Percent Unionized", 
    main="Unionization, by Region",
    vertical=TRUE, 
    method="jitter", 
    font.main=1)

#http://wiki.stdout.org/rcookbook/Manipulating%20data/Summarizing%20data/
#http://stackoverflow.com/questions/4866467/how-to-compute-weighted-means-of-a-vector-within-factor-levels

#Exercise 1: nes, jobs.spending, partyid7, wt
#jobs.spending is additive scale of serv.spend.r + jobs.scale
#see file fed_spend for details
compmeans(nes$jobs.spending,nes$partyid7,w=nes$wt,plot=F)
#printC(compmeans(nes$jobs.spending,nes$partyid7,w=nes$wt,plot=F))
wtd.boxplot(nes$jobs.spending~nes$partyid7, weights=nes$wt, 
 col="lightgray",
 varwidth=T, 
 xlab="Party ID", 
 ylab="Pro-spending Scale Score",
 main="Jobs and Spending Scale, by Party ID")
obj1=ddply(nes, .(partyid7), summarise, 
  ProSpend = wtd.mean(jobs.spending,wt))
obj1
plotmeans(ProSpend~partyid7, data=obj1, 
  xlab="Party ID",
  ylab="Pro-spending Scale", 
  main="Pro-spending Opinions, by Party ID",
  n.label=F,lwd=2,pch=16, font.main=1)

#Exercise 2: nes, gay.marriage3, relig.attend.f, wt
xtp(nes,gay.marriage3,relig.attend.f,wt,ylab="Opinion on Gay Marriage",
 xlab="Religious attendance", main="Gay Marriage Opinions, by Religious Attendance")
levels(nes$gay.marriage3)
nes$gay.marriage.yes=as.numeric(nes$gay.marriage3=="Yes")
freq(nes$gay.marriage.yes,nes$wt)

obj1=ddply(nes, .(relig.attend.f), summarise, ProGaymarriage = wtd.mean(gay.marriage.yes,wt))
print(obj1)
plotmeans(ProGaymarriage*100~relig.attend.f, data=obj1,
 xlab="Religious Attendance",ylab="Percentage", 
 main="Percent Supporting Gay Marriage,\n by Religious Attendance",
 n.label=F,lwd=2,pch=16, font.main=1)

#Not run: gss, fem.role, polviews
#levels(gss$polviews)=c("ExtLib","Lib","SlghtLib","Mod","SlghtCon","Con","ExtCon")
#run compmeans but suppress plot
#compmeans(gss$fem.role,gss$polviews,gss$wtss,plot=F)
#use ddply and plotMeans to obtain line chart
#obj1=ddply(gss, .(polviews), summarise, FemRole=wtd.mean(fem.role,wtss))
#print(obj1)
#plotmeans(FemRole~polviews,data=obj1, xlab="Ideology", ylab="Mean", 
#  main="Opinions on Female Roles, by Ideology",
#  n.label=F,lwd=2,pch=16,font.main=1)

#Exercise 3: gss, muslim.tol, educ4, wtss
xtp(gss,muslim.tol,educ4,wtss,xlab="Education",ylab="Tolerance",main="Tolerance for 
  Radical Muslims, by Education")
levels(gss$muslim.tol)
gss$muslim.tol.high=as.numeric(muslim.tol=="High")
#freq(gss$muslim.tol.high,gss$wtss)
obj1=ddply(gss, .(educ4), summarise, MuslimTolHigh=wtd.mean(muslim.tol.high,wtss))
print(obj1)
plotmeans(MuslimTolHigh*100~educ4,data=obj1,xlab="Education", ylab="Percent", 
  main="Percent Tolerant toward \n Radical Muslims, by Education",
  n.label=F,lwd=2,pch=16,font.main=1)

#Exercise 4: world, durable, regime.type3
compmeans(world$durable,world$regime.type3, plot=F)
printC(compmeans(world$durable,world$regime.type3, plot=F))
stripchart(durable ~ regime.type3, vertical=TRUE, method="jitter", 
  xlab="Regime type", ylab="Regime duration (years)", data=world)
#Mean comparison, plus interpetation of dispersion






